using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace konveksan
{
    internal class Program
    {
        public struct P
        {
            public long a;
            public long b;
            public P(long a, long b)
            {
                this.a = a;
                this.b = b;
            }
        }
        private static long o(P x, P y, P z)
        {
            return (y.a - x.a) * (z.b - y.b) - (y.b - x.b) * (z.a - y.a);
        }
        private static long s(List<P> l)
        {
            long o = 0;
            int m = l.Count;
            for (int i = 0; i < m; i++)
            {
                int t = (i + 1) % m;
                o += l[i].a * l[t].b;
                o -= l[i].b * l[t].a;
            }
            return Math.Abs(o) / 2;
        }
        private static List<P> k(List<P> p)
        {
            if (p.Count < 3)
                return new List<P>();

            p.Sort((x, y) =>
            {
                if (x.a != y.a)
                    return x.a.CompareTo(y.a);
                return x.b.CompareTo(y.b);
            });

            List<P> n = new List<P>();
            foreach (var z in p)
            {
                while (n.Count >= 2 && o(n[n.Count - 2], n[n.Count - 1], z) <= 0)
                    n.RemoveAt(n.Count - 1);
                n.Add(z);
            }

            List<P> v = new List<P>();
            for (int i = p.Count - 1; i >= 0; i--)
            {
                var z = p[i];
                while (v.Count >= 2 && o(v[v.Count - 2], v[v.Count - 1], z) <= 0)
                    v.RemoveAt(v.Count - 1);
                v.Add(z);
            }

            v.RemoveAt(v.Count - 1);
            n.RemoveAt(n.Count - 1);
            n.AddRange(v);

            return n;
        }
        static void Main(string[] args)
        {
            int m = int.Parse(Console.ReadLine());
            List<P> p = new List<P>();
            for (int i = 0; i < m; i++)
            {
                string[] u = Console.ReadLine().Split();
                long a = long.Parse(u[0]);
                long b = long.Parse(u[1]);
                p.Add(new P(a, b));
            }
            List<P> o = k(p);
            if (o.Count < 3)
            {
                Console.WriteLine(0);
                return;
            }
            long t = long.MaxValue;
            for (int i = 0; i < o.Count; i++)
            {
                List<P> pCopy = new List<P>(p);
                pCopy.Remove(o[i]);
                List<P> kCopy = k(pCopy);
                long sValue = s(kCopy);
                t = Math.Min(t, sValue);
            }
            Console.WriteLine(t);
        }

    }
}